<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:inr="http://mycompany.com/mynamespace">
    <!-- The following Java Script functions are the functions used to format -->
    <!-- the numbers from the InRoads XML data structure.  You can use these  -->
    <!-- as is, or modify or replace them with your own formatting functions. -->
    <!-- These functions are not required to create reports.                  -->
    <msxsl:script implements-prefix="inr" language="JScript">
        <![CDATA[
            // Decimal Separator
            var decSep = ".";
            function SetDecSep( dS )
            {
                decSep = dS;
                return 1;
            }

            // Grid factors functions
            var gridIn = 1.0;
            var gridOut = 1.0;
            function SetGridIn(gIn)
            {
                if (!isNaN(gIn))
                {
                    gridIn = gIn;
                }
                return 1;
            }
            function SetGridOut(gOut)
            {
                if (!isNaN(gOut))
                {
                    gridOut = gOut;
                }
                return 1;
            }

            // Sets whether to include the angular suffix or not
            var useAngSuffix = false;
            function UseAngSuffix( bAngSuffix )
            {
                useAngSuffix = bAngSuffix;
                return 1;
            }

            // This function gets the current date.
            function date()
            {
                var today = new Date();
                var month = today.getMonth() + 1;
                var dayOfMonth = today.getDate();
                var year = today.getFullYear();
                var hours = today.getHours();
                var setting = "";
                if (hours == 12)
                {
                    setting = "pm";
                }
                if (hours == 24)
                {
                    setting = "am";
                }
                if (hours < 12)
                {
                    setting = "am";
                }
                if (hours > 12)
                {
                    setting = "pm";
                    hours = hours - 12;
                }
                var minutes = today.getMinutes();
                if (minutes < 10)
                {
                    minutes = "0" + minutes;
                }
                return month + "/" + dayOfMonth + "/" + year;
            }

            // This function gets the current time.
            function time()
            {
                var today = new Date();
                var hours = today.getHours();
                var setting = "";
                if (hours == 12)
                {
                    setting = "pm";
                }
                if (hours == 24)
                {
                    setting = "am";
                }
                if (hours < 12)
                {
                    setting = "am";
                }
                if (hours > 12)
                {
                    setting = "pm";
                    hours = hours - 12;
                }
                var minutes = today.getMinutes();
                if (minutes < 10)
                {
                    minutes = "0" + minutes;
                }
                return hours + ":" + minutes + setting;
            }

            // This function returns a locale-specific long date
            function localeDate()
            {
                var today = new Date();
                return today.toLocaleDateString();
            }

            // This function returns a locale-specific long time
            function localeTime()
            {
                var today = new Date();
                return today.toLocaleTimeString();
            }

            // This function returns the absolute vaule of a number
            function absolut(num)
            {
                if (!isNaN(num))
                {
                    var absolutenum = Math.abs(num);
                    return absolutenum;
                }
                else
                {
                    return num;
                }
            }

            // This function formats a number to a specified precision.
            // It pads it with 0's if needed.
            // num - number from the xml
            // prec - number of decimal places after the decimal point
            function formatNumber(num, prec)
            {
                // Make sure we have a valid number
                if (!isNaN(num))
                {
                    if (num < 0)
                    {
                        //takes the absolute value of num
                        var absolutenum = Math.abs(num); 
                        var str = "" + Math.round(absolutenum * Math.pow(10, prec));
                        var absolutenum = Math.abs(num);
                        while (str.length <= prec)
                        {
                            str = "0" + str;
                        }
                        var decpoint = str.length - prec;
                        // replaces the negative sign if the number was
                        // negative
                        if (prec != 0)
                        {
                            return "-" + str.substring(0, decpoint) + decSep + str.substring(decpoint, str.length);
                        }
                        else
                        {
                            return "-" + str;
                        }
                    }
                    else
                    {
                        var str = "" + Math.round (num * Math.pow(10,prec));
                        while (str.length <= prec)
                        {
                            str = "0" + str;
                        }
                        var decpoint = str.length - prec;
                        if (prec != 0)
                        {
                            return str.substring(0, decpoint) + decSep + str.substring(decpoint, str.length);
                        }
                        else
                        {
                            return str;
                        }
                    }
                }
                return num;
            }

            // This function formats a station value, adds the prefix,
            // and gets the specified precision.
            // n - station value
            // format - the format (1 - "ssss.ss", 2 - "sss+ss.ss",
            // 3 - "ss+sss.ss")
            // precision - the number of digits after the decimal point
            function stationFormat(n, format, precision, externalStatName)
            {
                var str = "";
                // Make sure we have a valid number
                if (!isNaN(n))
                {
                    // take the absolute value of the number
                    var abs = Math.abs(n);
                    // this calls the function that gives the number
                    // the correct precision
                    str = formatNumber(abs, precision);
                    // format 2 - "sss+ss.ss", format 3 - "ss+sss.ss"
                    if (format == 2 || format == 3)
                    {
                        var smallN;
                        // format 1 - "ss+sss.ss"
                        if (format == 3)
                        {
                            smallN = 3;
                        }
                        else
                        {
                            smallN = 2;
                        }
                        var decpoint;
                        if (precision == 0)
                        {
                            decpoint = str.length;
                        }
                        else
                        {
                            decpoint = str.indexOf(decSep, 0);
                        }
                        // pad left side with zeros
                        while (decpoint < smallN + 1)
                        {
                            str = "0" + str;
                            decpoint++;
                        }
                        //places the "+" sign in the number
                        str = str.substring(0, decpoint - smallN) + "+" + str.substring(decpoint - smallN, str.length);
                        // in case the number is negative
                        if (n < 0)
                        {
                            if (externalStatName != "")
                            {
                                return externalStatName + " " + "-" + str;
                            }
                            else
                            {
                                return "-" + str;
                            }
                        }
                        else
                        {
                            if (externalStatName != "")
                            {
                                return externalStatName + " " + str;
                            }
                            else
                            {
                                return str;
                            }
                        }
                    }
                    else
                    {
                        if (n < 0)
                        {
                            if (externalStatName != "")
                            {
                                return externalStatName + " " + "-" + str;
                            }
                            else
                            {
                                return "-" + str;
                            }
                        }
                        else
                        {
                            if (externalStatName != "")
                            {
                                return externalStatName + " " + str;
                            }
                            else
                            {
                                return str;
                            }
                        }
                    }
                }
                return "";
            }

            // This function formats the grade or slope and adjusts the
            // precision according to input
            // n - grade value
            // format - 1 - .50            2 - 50%
            //          3 - 0.5:1          4 - 0.5':1'
            //          5 - 6":1'          6 - 12/2":1'
            //          7 - 24/4":1'       8 - 48/8":1'
            //          9 - 96/16":1'      10 - 1:2.0
            //          11 - 500%o         12 - 2.0:1
            // precision - the number of digits after the decimal
            function gradeFormat(n, format, precision)
            {
                var str = "";
                // Make sure we have a valid number
                if (!isNaN(n))
                {
                    // format 1 - .50
                    if (format == 1)
                    {
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(n, precision);
                        return str;
                    }
                    // format 2 - 50%
                    if (format == 2)
                    {
                        var value = (n * 100);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + "%";
                    }
                    // format 3 -  0.5:1
                    if (format == 3)
                    {
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(n, precision);
                        return str + ":" + "1";
                    }
                    // format 4 - 0.5':1'
                    if (format == 4)
                    {
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(n,precision);
                        return str+ "'" + ":" + "1" +"'";
                    }
                    // format 5 - 6":1'
                    if (format == 5)
                    {
                        var value = (n * 12);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + '"' + ":" + "1" + "'";
                    }
                    // format 6 - 12/2":1'
                    if (format == 6)
                    {
                        var value = (n * 24);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + "/" + "2" + '"' + ":" + "1" + "'";
                    }
                    // format 7 - 24/4":1'
                    if (format == 7)
                    {
                        var value = (n * 48);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + "/" + "4" + '"' + ":" + "1" + "'";
                    }
                    // format 8 - 48/8":1'
                    if (format == 8)
                    {
                        var value = (n * 96);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + "/" + "8" + '"' + ":" + "1" + "'";
                    }
                    // format 9 - 96/16":1'
                    if (format == 9)
                    {
                        var value = (n * 192);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision); 
                        return str + "/" + "16" + '"' + ":" + "1" + "'";
                    }
                    // format 10 - 1:2.0
                    if (format == 10)
                    {
                        if ( n == 0 )
                        {
                            precision = 0;
                        }
                        var value = (1 / n);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return "1" + ":" + str;
                    }
                    // format 11 - 500%o
                    if (format == 11)
                    {
                        var value = (n * 1000);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + "%"+"o";
                    }
                    // format 12 - 2.0:1
                    if (format == 12)
                    {
                        if ( n == 0 )
                        {
                            precision = 0;
                        }
                        var value = (1 / n);
                        // this calls the function that gives the number
                        // the correct precision
                        str = formatNumber(value, precision);
                        return str + ":" + "1";
                    }
                }
                return "";
            }

            // This function formats the grade or slope and adjusts the
            // precision according to input
            // n - grade value
            // format - 1 - .50            2 - 50%
            //          3 - 0.5:1          4 - 0.5':1'
            //          5 - 6":1'          6 - 12/2":1'
            //          7 - 24/4":1'       8 - 48/8":1'
            //          9 - 96/16":1'      10 - 1:2.0
            //          11 - 500%o         12 - 2.0:1
            // precision - the number of digits after the decimal
            function alternateGradeFormat(n, format, precision, exceedslope, altformat, altprecision)
            {
                var str = "";
                // Make sure we have a valid number
                if (!isNaN(n))
                {
                    if (n > (-1 * exceedslope) && n < exceedslope)
                    {
                        str = gradeFormat(n, format, precision);
                        return str;
                    }
                    else
                    {
                        // format 1 - .50
                        if (altformat == 1)
                        {
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(n, altprecision);
                            return str;
                        }
                        // format 2 - 50%
                        if (altformat == 2)
                        {
                            var value = (n * 100);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + "%";
                        }
                        // format 3 -  0.5:1
                        if (altformat == 3)
                        {
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(n, altprecision);
                            return str + ":" + "1";
                        }
                        // format 4 - 0.5':1'
                        if (altformat == 4)
                        {
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(n, altprecision);
                            return str+ "'" + ":" + "1" +"'";
                        }
                        // format 5 - 6":1'
                        if (altformat == 5)
                        {
                            var value = (n * 12);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + '"' + ":" + "1" + "'";
                        }
                        // format 6 - 12/2":1'
                        if (altformat == 6)
                        {
                            var value = (n * 24);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + "/" + "2" + '"' + ":" + "1" + "'";
                        }
                        // format 7 - 24/4":1'
                        if (altformat == 7)
                        {
                            var value = (n * 48);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + "/" + "4" + '"' + ":" + "1" + "'";
                        }
                        // format 8 - 48/8":1'
                        if (altformat == 8)
                        {
                            var value = (n * 96);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + "/" + "8" + '"' + ":" + "1" + "'";
                        }
                        // format 9 - 96/16":1'
                        if (altformat == 9)
                        {
                            var value = (n * 192);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision); 
                            return str + "/" + "16" + '"' + ":" + "1" + "'";
                        }
                        // format 10 - 1:2.0
                        if (altformat == 10)
                        {
                            if ( n == 0 )
                            {
                                altprecision = 0;
                            }
                            var value = (1 / n);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return "1" + ":" + str;
                        }
                        // format 11 - 500%o
                        if (altformat == 11)
                        {
                            var value = (n * 1000);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + "%"+"o";
                        }
                        // format 12 - 2.0:1
                        if (altformat == 12)
                        {
                            if ( n == 0 )
                            {
                                altprecision = 0;
                            }
                            var value = (1 / n);
                            // this calls the function that gives the number
                            // the correct precision
                            str = formatNumber(value, altprecision);
                            return str + ":" + "1";
                        }
                    }
                }
                return "";
            }

            // This function sets the format of directional information.
            // n - value from XML
            // format - (1 - "ddd^mm'ss.s", 2 - "ddd.ddd")
            // precision - the number of digits after the decimal point
            // mode - (1 - Bearing, 2 - Bearings from North Only,
            //         3 - North Azimuth, 4 - South Azimuth)
            function directionFormat(n, format, precision, mode, method)
            {
                // Make sure we have a valid number
                if (!isNaN(n))
                {   
                    // this adds 360 to a negative number until it
                    // becomes positive
                    while (n < 0)
                    {
                        n += (2 * Math.PI);
                    }
                    // this subtracts 360 if the number is greater
                    // than 360
                    while (n >= (2 * Math.PI))
                    {
                        n -= (2 * Math.PI);
                    }
                    
                    //mode 1 - Bearing, mode 2 - North Bearing
                    if (mode == 1 || mode == 2)
                    {
                        var decdeg = (n * 180) / Math.PI;
                        
                        //identifies the quadrant
                        if (decdeg <= 90)
                        {
                            var strAngle = angularFormat(n, format, precision, method);
                            return "N " + strAngle + " E";
                        }
                        //identifies the quadrant
                        if (90 < decdeg && decdeg <= 180)
                        {
                            n = Math.PI - n;
                            var strAngle = angularFormat(n, format, precision, method);
                            if(mode == 1)
                            {
                                return "S " + strAngle + " E";
                            }
                            else
                            {
                                return "N " + strAngle + " W";
                            }
                        }
                        //identifies the quadrant 
                        if (180 < decdeg && decdeg < 270)
                        {
                            n -= Math.PI;
                            var strAngle = angularFormat(n, format, precision, method);
                            if(mode == 1)
                            {
                                return "S " + strAngle + " W";
                            }
                            else
                            {
                                return "N " + strAngle + " E";
                            }
                        }
                        //identifies the quadrant
                        if (270 <= decdeg && decdeg < 360)
                        {
                            n = (2.0 * Math.PI) - n;
                            var strAngle = angularFormat(n, format, precision, method);
                            return "N " + strAngle + " W";
                        }
                    }
                    // mode 3 - North Azimuth
                    if (mode == 3)
                    {
                        var strAngle = angularFormat(n, format, precision, method);
                        return strAngle;
                    }
                    // mode 4 - South Azimuth
                    if (mode == 4)
                    {
                        n = n + Math.PI;
                        if ( n >= (2.0 * Math.PI) )
                        {
                            n = n - (2.0 * Math.PI);
                        }
                        var strAngle = angularFormat(n, format, precision, method);
                        return strAngle;
                     }
                }
                return "";
             }

            // This function sets the format of angular information.
            // n - value from xml
            // format - (1 - "ddd^mm'ss.s", 2 - "ddd.ddd")
            // formatMethod - (1 - Degrees, 2 - Grads, 3 - Radians, 4 - Mils)
            // precision - the number of digits after the decimal point
            function angularFormat(n, format, precision, formatMethod)
            {
                // Checking to see if the number is valid
                if (!isNaN(n))
                {
                    // converts from Radians to Degrees and formats the
                    // value
                    if (formatMethod == 1)
                    {
                        var decdeg = (n * 180) / Math.PI;
                        // format 1 - this converts the number to
                        // "ddd^mm'ss.s"
                        if (format == 1)
                        {
                            // takes only the whole number (ddd)
                            deg = Math.floor(Math.abs(decdeg));
                            
                            // multiplies the decimal portion time 60 to get the minutes.
                            var decmin = (Math.abs(decdeg) - deg) * 60;
                            
                            // takes only the whole part of that number (mm')
                            var min = Math.floor(decmin);
                            
                            // multiplies the decimal portion time 60 to get the seconds.
                            var decsec = (decmin - min) * 60;
                            
                            // this calls the function that gives the number the correct precision
                            var str = formatNumber(decsec, precision);
                            
                            if (  str.substring(0,2) == "60" )
                            {
                                decsec = 0;
                                str = formatNumber(decsec, precision);
                                min = min+1;
                                if ( min == 60 )
                                {
                                    min = 0;
                                    deg = deg + 1;
                                }
                            }
                                
                            if ( min < 10 )
                            {
                                min = "0" + min;
                            }
                            var sec = str;
                            if ( sec < 10 )
                            {
                                sec = "0" + sec;
                            }
                            
                            var msg;
                            if( decdeg >= 0 || decdeg <= -1 )
                            {
                                if( decdeg < 0 )
                                    msg =  "-" + deg + unescape("%b0") + min + "'" + sec + '"';
                                else
                                    msg =  deg + unescape("%b0") + min + "'" + sec + '"';
                            }
                            else
                                msg =  "-0" + unescape("%b0") + min + "'" + sec + '"';
                                
                            return msg;
                        }
                        // format 2 - "ddd.ddd"
                        if (format == 2)
                        {
                            // this calls the function that gives the
                            // number the correct precision
                            var str = formatNumber(decdeg, precision);
                            if (useAngSuffix == true)
                            {
                                str = str + unescape("%b0");
                            }
                            return str;
                        }
                    }
                    //converts Radians to Grads
                    if (formatMethod == 2)
                    {
                        var radtograd = (n * 200) / Math.PI;
                        var grad = formatNumber(radtograd, precision);
                        if (useAngSuffix == true)
                        {
                            grad = grad + "g";
                        }
                        return grad;
                    }
                    // value in Radians needs to be formated
                    if (formatMethod == 3)
                    {
                        // this calls the function that gives the number
                        // the correct precision
                        var radian = formatNumber(n, precision);
                        if (useAngSuffix == true)
                        {
                            radian = radian + "r";
                        }
                        return radian;
                    }
                    //converts Radians to Mils
                    if (formatMethod == 4 )
                    {
                         var radtomils = n * (6400.0 / (2.0 * Math.PI));
                         var mils = formatNumber( radtomils, precision );
                         return mils;
                    }
                }
                return 985;
             }

            // This function sets the suffix and precision for the
            // distance values.
            // n - distance value
            // precision - the number of digits after the decimal point
            function distanceFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                if (!isNaN(n))
                {
                     str = formatNumber(n, precision);
                }
                return str;
            }

            // This function sets the prefix and precision for the
            // northing values.
            // n - northing value
            // precision - the number of digits after the decimal point
            function northingFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                str = formatNumber(n, precision);
                return str;
            }

            // This function sets the prefix and precision for the
            // easting values.
            // n - easting value
            // precision - the number of digits after the decimal point
            function eastingFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                str = formatNumber(n, precision);
                return str;
            }
            
            // This function sets the prefix and precision for the
            // elevation values.
            // n - elevation value
            // precision - the number of digits after the decimal point
            function elevationFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                str = formatNumber(n, precision);
                return str;
            }

            // This function sets the precision for the acre values.
            // n - acre value
            // precision - the number of digits after the decimal point
            function acreFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                if (!isNaN(n))
                {
                    str = formatNumber(n, precision);
                }
                return str;
            }

            // This function sets the precision for the area unit values.
            // n - area unit value
            // precision - the number of digits after the decimal point
            function areaFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                if (!isNaN(n))
                {
                    str = formatNumber(n, precision);
                }
                return str;
            }

            // This function sets the precision for the cubic unit values.
            // n - cubic unit value
            // precision - the number of digits after the decimal point
            function cubicFormat(n, precision)
            {
                var str = "";
                // this calls the function that gives the
                // number the correct precision
                if (!isNaN(n))
                {
                    str = formatNumber(n, precision);
                }
                return str;
            }

            // This Function formats a string with a length
            // strString - String to get formated
            // nLength - Length of returned string
            function columnFormat( strString, nLength )
            {
                var i = 0;
                var nBlanks = nLength - strString.length;
                for( i = 0; i < nBlanks; i++ )
                    strString = " " + strString;
                return strString;
            }

            // This function converts a double to string and sets precision and length 
            // dNum - Double to be converted to String
            // nPrecision - the number of digits after the decimal point
            // nLength - Length of returned string
            function columnDoubleFormat( dNum, nPrecision, nLength )
            {
                var i = 0, j = 0;
                var strResult = formatNumber(dNum, nPrecision)
                if( strResult.indexOf( decSep ) == -1 )
                    strResult += decSep;
                var nCount = strResult.length - strResult.indexOf( decSep ) - 1;
                for( j = 0; j < (nPrecision - nCount); j++ )
                    strResult += "0";
                var nBlanks = nLength - strResult.length;
                for( i = 0; i < nBlanks; i++ )
                    strResult = " " + strResult;
                return strResult;
            }

            //This function converts a double to a double considering the Face setting
            //n = direction value
            //format = FACE_MODE_RIGHT_FACE or FACE_MODE_LEFT_FACE
            function faceFormat( n, format )
            {
                var dFormattedValue = n;
                if( !isNaN( n ) )
                {
                    if( format == 2 )
                        dFormattedValue -= (2.0*Math.PI);
                }
                return dFormattedValue;
            }

            //This function converts a double to a double considering the Vertical
            //Observation setting.
            //n = direction value
            //format = VERTICAL_OBSERVATION_MODE_ZENITH, VERTICAL_OBSERVATION_MODE_HORIZONTAL, or VERTICAL_OBSERVATION_MODE_HORIZONTAL_PM
            function verticalObservationFormat( n, format )
            {
                var dFormattedValue = n;
                var dHalfPI = Math.PI * 0.5;
                if( !isNaN( n ) )
                {
                    if( format == 2 )
                    {
                        if( dHalfPI  < dFormattedValue )
                            dFormattedValue = (2.0 * Math.PI) + (dHalfPI - n);
                        else
                            dFormattedValue = dHalfPI - n;
                    }
                    else if( format == 3 )
                    {
                        if( ( 1.5 * Math.PI ) < n && n <= (2.0 * Math.PI ) )
                            dFormattedValue = 2.0 * Math.PI + (dHalfPI - n );
                        else
                            dFormattedValue = dHalfPI - n;
                    }
                }
                return dFormattedValue;
            }
        ]]>
    </msxsl:script>
    <!-- The following parameters are defined for convienence.  They are  -->
    <!-- used in the sample reports, but are not necessary unless you are -->
    <!-- creating reports that use them.  The values of these parameters  -->
    <!-- are set by the user through Tools > Format Options in the Report -->
    <!-- Browser.  The default values set by the select attribute below.  -->
    <!-- InRoads constants -->
    <xsl:variable name="STATION_FORMAT_SSSS" select="'0'"/>
    <xsl:variable name="STATION_FORMAT_S_SSS" select="'1'"/>
    <xsl:variable name="STATION_FORMAT_SS_SS" select="'2'"/>

    <!-- Grade format samples:             -->
    <!--      1 - .50         2 - 50%      -->
    <!--      3 - 0.5:1       4 - 0.5':1'  -->
    <!--      5 - 6":1'       6 - 12/2":1' -->
    <!--      7 - 24/4":1'    8 - 48/8":1' -->
    <!--      9 - 96/16":1'   10 - 1:2.0   -->
    <!--      11 - 500%o      12 - 2.0:1   -->
    <xsl:variable name="GRADE_FORMAT_DEC" select="'1'"/>
    <xsl:variable name="GRADE_FORMAT_PERCENT" select="'2'"/>
    <xsl:variable name="GRADE_FORMAT_RATIO_TO_1" select="'3'"/>
    <xsl:variable name="GRADE_FORMAT_RATIO_TO_1_FT" select="'4'"/>
    <xsl:variable name="GRADE_FORMAT_INCHES_TO_FOOT" select="'5'"/>
    <xsl:variable name="GRADE_FORMAT_HALF_INCHES_TO_FOOT" select="'6'"/>
    <xsl:variable name="GRADE_FORMAT_QUARTER_INCHES_TO_FOOT" select="'7'"/>
    <xsl:variable name="GRADE_FORMAT_EIGHTH_INCHES_TO_FOOT" select="'8'"/>
    <xsl:variable name="GRADE_FORMAT_SIXTEENTH_INCHES_TO_FOOT" select="'9'"/>
    <xsl:variable name="GRADE_FORMAT_RATIO_ONE_TO" select="'10'"/>
    <xsl:variable name="GRADE_FORMAT_RATIO_PERCENT_O" select="'11'"/>
    <xsl:variable name="GRADE_FORMAT_RATIO_LARGER_TO_ONE" select="'12'"/>
    <xsl:variable name="ALTGRADE_FORMAT_DEC" select="'1'"/>
    <xsl:variable name="ALTGRADE_FORMAT_PERCENT" select="'2'"/>
    <xsl:variable name="ALTGRADE_FORMAT_RATIO_TO_1" select="'3'"/>
    <xsl:variable name="ALTGRADE_FORMAT_RATIO_TO_1_FT" select="'4'"/>
    <xsl:variable name="ALTGRADE_FORMAT_INCHES_TO_FOOT" select="'5'"/>
    <xsl:variable name="ALTGRADE_FORMAT_HALF_INCHES_TO_FOOT" select="'6'"/>
    <xsl:variable name="ALTGRADE_FORMAT_QUARTER_INCHES_TO_FOOT" select="'7'"/>
    <xsl:variable name="ALTGRADE_FORMAT_EIGHTH_INCHES_TO_FOOT" select="'8'"/>
    <xsl:variable name="ALTGRADE_FORMAT_SIXTEENTH_INCHES_TO_FOOT" select="'9'"/>
    <xsl:variable name="ALTGRADE_FORMAT_RATIO_ONE_TO" select="'10'"/>
    <xsl:variable name="ALTGRADE_FORMAT_RATIO_PERCENT_O" select="'11'"/>
    <xsl:variable name="ALTGRADE_FORMAT_RATIO_LARGER_TO_ONE" select="'12'"/>

    <xsl:variable name="DIRECTION_FORMAT_DMS" select="'1'"/>
    <xsl:variable name="DIRECTION_FORMAT_DECDEG" select="'2'"/>

    <xsl:variable name="DIRECTION_MODE_BEARING" select="'1'"/>
    <xsl:variable name="DIRECTION_MODE_NORTH_BEARING" select="'2'"/>
    <xsl:variable name="DIRECTION_MODE_NORTH_AZIMUTH" select="'3'"/>
    <xsl:variable name="DIRECTION_MODE_SOUTH_AZIMUTH" select="'4'"/>

    <xsl:variable name="ANGULAR_FORMAT_DMS" select="'1'"/>
    <xsl:variable name="ANGULAR_FORMAT_DECDEG" select="'2'"/>

    <xsl:variable name="ANGULAR_METHOD_DECIMAL" select="'1'"/>
    <xsl:variable name="ANGULAR_METHOD_GRADS" select="'2'"/>
    <xsl:variable name="ANGULAR_METHOD_RADIANS" select="'3'"/>
    <xsl:variable name="ANGULAR_METHOD_MILS" select="'4'"/>

    <xsl:variable name="FACE_MODE_RIGHT_FACE" select="1"/>
    <xsl:variable name="FACE_MODE_LEFT_FACE" select="2"/>
    
    <xsl:variable name="VERTICAL_OBSERVATION_MODE_ZENITH" select="1"/>
    <xsl:variable name="VERTICAL_OBSERVATION_MODE_HORIZONTAL" select="'2'"/>
    <xsl:variable name="VERTICAL_OBSERVATION_MODE_HORIZONTAL_PM" select="'3'"/>

    <xsl:variable name="CONVERT_TO_CY" select="'1'"/>
    <xsl:variable name="INCLUDE_ANGULAR_SUFFIX" select="'0'"/>

    <!-- precision parameters -->
    <xsl:param name="xslStationPrecision" select="'3'"/>
    <xsl:param name="xslDistancePrecision" select="'3'"/>
    <xsl:param name="xslNorthingPrecision" select="'3'"/>
    <xsl:param name="xslEastingPrecision" select="'3'"/>
    <xsl:param name="xslElevationPrecision" select="'3'"/>
    <xsl:param name="xslGradePrecision" select="'2'"/>
    <xsl:param name="xslAlternateSlopePrecision" select="'0'"/>
    <xsl:param name="xslDirectionPrecision" select="'1'"/>
    <xsl:param name="xslAngularPrecision" select="'1'"/>
    <xsl:param name="xslAcrePrecision" select="'3'"/>
    <xsl:param name="xslAreaPrecision" select="'0'"/>
    <xsl:param name="xslCubicPrecision" select="'0'"/>

    <!-- format number parameters -->
    <xsl:param name="xslStationFormat" select="$STATION_FORMAT_SS_SS"/>
    <xsl:param name="xslGradeFormat" select="$GRADE_FORMAT_PERCENT"/>
    <xsl:param name="xslAlternateSlopeFormat" select="$ALTGRADE_FORMAT_RATIO_LARGER_TO_ONE"/>
    <xsl:param name="xslDirectionFormat" select="$DIRECTION_FORMAT_DMS"/>
    <xsl:param name="xslDirectionModeFormat" select="$DIRECTION_MODE_BEARING"/>
    <xsl:param name="xslFaceModeFormat" select="$FACE_MODE_RIGHT_FACE"/>
    <xsl:param name="xslVerticalObservationModeFormat" select="$VERTICAL_OBSERVATION_MODE_ZENITH"/>
    <xsl:param name="xslAngularFormat" select="$ANGULAR_FORMAT_DMS"/>
    <xsl:param name="xslAngularMethod" select="$ANGULAR_METHOD_RADIANS"/>

  <!-- misc parameters -->
    <xsl:param name="xslIfSlopeExceeds" select="'0.2'"/>
    <xsl:param name="xslConvertToCY" select="$CONVERT_TO_CY"/>
    <xsl:param name="xslIncludeAngularSuffix" select="$INCLUDE_ANGULAR_SUFFIX"/>
    <xsl:variable name="IncludeAngularSuffix" select="inr:UseAngSuffix( $xslIncludeAngularSuffix )"/>
    <xsl:param name="xslDecimalSeparator" select="'.'"/>
    <xsl:variable name="DecSep" select="inr:SetDecSep( $xslDecimalSeparator )"/>
    <xsl:param name="xslShowHelp" select="'false'"/>

</xsl:stylesheet>
