<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Cant Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Cant Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Last Revised:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />

                                <table cellpadding="1" width="100%">
                                    <xsl:for-each select="HorizontalAlignment[*/CantAlignment]">
                                        <tr>
                                            <th align="right" lang="en" width="20%"><br/>Horizontal Alignment:&#xa0; </th>
                                            <td align="left" valign="bottom" width="80%"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="white-space:nowrap;">Horizontal Description:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Horizontal Style:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@style"/></td>
                                        </tr>
                                        <xsl:for-each select="Superelevation/CantAlignment">
                                            <tr>
                                                <th align="right" lang="en"><br/>Cant Name:&#xa0; </th>
                                                <td align="left" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" lang="en">Cant Description:&#xa0; </th>
                                                <td align="left"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <td colspan="12">
                                                    <table width="100%">
                                                        <xsl:if test="//@linearUnits = 'Imperial'">
                                                            <tr>
                                                                <th class="underline" lang="en" valign="bottom">Element</th>
                                                                <th class="underline" lang="en" valign="bottom">Start Station</th>
                                                                <th class="underline" lang="en" valign="bottom">End Station</th>
                                                                <th class="underline" lang="en" valign="bottom">Speed<br/>(mph)</th>
                                                                <th class="underline" lang="en" valign="bottom">Start Cant<br/>(in)</th>
                                                                <th class="underline" lang="en" valign="bottom">End Cant<br/>(in)</th>
                                                            </tr>
                                                        </xsl:if>
                                                        <xsl:if test="//@linearUnits = 'Metric'">
                                                            <tr>
                                                                <th class="underline" lang="en" valign="bottom">Element</th>
                                                                <th class="underline" lang="en" valign="bottom">Start Station</th>
                                                                <th class="underline" lang="en" valign="bottom">End Station</th>
                                                                <th class="underline" lang="en" valign="bottom">Speed<br/>(kph)</th>
                                                                <th class="underline" lang="en" valign="bottom">Start Cant<br/>(mm)</th>
                                                                <th class="underline" lang="en" valign="bottom">End Cant<br/>(mm)</th>
                                                            </tr>
                                                        </xsl:if>

                                                        <xsl:for-each select="Cant">
                                                            <tr>
                                                                <xsl:if test="position() != last()">
                                                                    <td align="right">
                                                                        <xsl:value-of select="@transitionType"/>
                                                                    </td>

                                                                    <td align="right" style="white-space:nowrap;">
                                                                        <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                                                                    </td>

                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
                                                                    </td>

                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:formatNumber(number(@designSpeed), 0)"/>
                                                                    </td>

                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:formatNumber(number(@appliedCant))"/>
                                                                    </td>

                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:formatNumber(number(following-sibling::*[1]/@appliedCant))"/>
                                                                    </td>
                                                                </xsl:if>
                                                            </tr>
                                                        </xsl:for-each>
                                                        <tr><td colspan="12">&#xa0;</td></tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must include at least one horizontal alignment in the <em>Include</em> field on the 
                <em>Tools &gt; XML Reports &gt; Geometry</em> command.
            </p>
            <p class="normal1" lang="en">
                You must also toggle on the <em>Include Cant Alignments</em> option and select either 
                <em>All</em> or <em>Active</em> to get results from this report.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2014 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
