<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif: xslShowHelp" />
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:variable name="numberAlign" select="count(//HorizontalAlignment)"/>
    <!-- Horizontal Alignment Curve Set Element Review Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Horizontal Alignment Curve Set Element Review Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Horizontal Alignment Curve Set Element Review Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/>
                                    <br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Last Revised:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <table class="margin" width="90%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:choose>
                                        <xsl:when test="$numberAlign &gt; 1">
                                            <tr>
                                                <th colspan="5" lang="en" style="color:red">
                                                    This report is not suitable for multiple alignments.
                                                </th>
                                            </tr>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:for-each select="HorizontalAlignment[HorizontalCurveSets]">
                                                <tbody>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Alignment Name:&#xa0;</th>
                                                        <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                                    </tr>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Alignment Description:&#xa0;</th>
                                                        <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                                    </tr>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Alignment Style:&#xa0;</th>
                                                        <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                                    </tr>
                                                    <xsl:apply-templates/>
                                                    <tr><td colspan="5">&#xa0;</td></tr>
                                                </tbody>
                                            </xsl:for-each>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Curveset Point Data -->
    <xsl:template match="CurvesetPoint[@pointType != 'POB' and @pointType != 'POE' and @pointType != 'PI']">
        <tr>
            <td align="left" lang="en" valign="top"><br/>Curve Set Type:</td>
            <td align="left" colspan="4" valign="top"><br/><xsl:value-of select="@pointType"/></td>
        </tr>
        <tr>
            <th/>
            <th/>
            <th align="right" class="underline" lang="en">Station</th>
            <th align="right" class="underline" lang="en">Northing</th>
            <th align="right" class="underline" lang="en">Easting</th>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="GeometryPoint/@type"/></td>
            <td align="right"> ( <xsl:value-of select="GeometryPoint/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
            </td>
        </tr>
        <tr><td colspan="5">&#xa0;</td></tr>
        <tr>
            <td align="right" colspan="2" lang="en">Total Central Angle:</td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>
            </td>
            <td align="left" lang="en">
                <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection='cw'">Right</xsl:if>
                <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection = 'ccw'">Left</xsl:if>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">First Subtangent Distance:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@tangentLengthStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Second Subtangent Distance:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@tangentLengthEnd))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">External:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@external))"/>
            </td>
        </tr>
        <tr><td colspan="5">&#xa0;</td></tr>
        <xsl:call-template name="ElementData">
            <xsl:with-param name="startEle" select="@curveSetStartElement"/>
            <xsl:with-param name="stopEle" select="@curveSetStopElement"/>
        </xsl:call-template>
        <tr><td colspan="5"><hr size="1"/></td></tr>
    </xsl:template>
    <!-- Specify Element Data to Include by Start and End Elements of Curveset -->
    <xsl:template name="ElementData">
        <xsl:param name="startEle"/>
        <xsl:param name="stopEle"/>
        <xsl:variable name="nxtEle" select="$startEle + 1"/>
        <xsl:for-each select="//HorizontalElements">
            <xsl:apply-templates mode="Curveset">
                <xsl:with-param name="eleNum" select="$startEle"/>
            </xsl:apply-templates>
        </xsl:for-each>
        <xsl:if test="$nxtEle &lt;= $stopEle">
            <xsl:call-template name="ElementData">
                <xsl:with-param name="startEle" select="$nxtEle"/>
                <xsl:with-param name="stopEle" select="$stopEle"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!-- Horizontal Circular Data -->
    <xsl:template match="HorizontalCircle" mode="Curveset">
        <xsl:param name="eleNum"/>
        <xsl:if test="@elementNumber = $eleNum">
            <tr>
                <td align="left" colspan="5" lang="en"><br/>Element: Circular</td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="Start/@type"/></td>
                <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
                </td>
            </tr>
            <xsl:if test="PI">
                <tr>
                    <td align="right"><xsl:value-of select="PI/@type"/></td>
                    <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="Center/@type"/></td>
                <td align="right">( <xsl:value-of select="Center/@name"/> )</td>
                <td />
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Center/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Center/@easting))"/>
                </td>
            </tr>
            <xsl:if test="StationEquation">
                <xsl:for-each select="StationEquation">
                    <tr>
                        <td align="right" colspan="2" lang="en">EQNBK</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" colspan="2" lang="en">EQNAHD</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="End/@type"/></td>
                <td align="right">( <xsl:value-of select="End/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Radius:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Delta:</td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                </td>
                <td align="left" lang="en">
                    <xsl:if test="@rotationDirection='cw'">Right</xsl:if>
                    <xsl:if test="@rotationDirection = 'ccw'">Left</xsl:if>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">
                    <xsl:if test="../../@curvatureDefinition = 'arc'">
                         Degree of Curvature (Arc):
                    </xsl:if>
                    <xsl:if test="../../@curvatureDefinition = 'chord'">
                        Degree of Curvature (Chord):
                    </xsl:if>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Length:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Tangent:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Chord:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Middle Ordinate:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">External:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <!-- Horizontal Spiral Data -->
    <xsl:template match="HorizontalSpiral" mode="Curveset">
        <xsl:param name="eleNum"/>
        <xsl:if test="@elementNumber = $eleNum">
            <tr>
                <td align="left" colspan="5" lang="en"><br/>Element: 
                    <xsl:choose>
                        <xsl:when test="@compound = 'false'">
                            <xsl:value-of select="@type"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text> Compound </xsl:text>
                            <xsl:value-of select="@type"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="Start/@type"/></td>
                <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="PI/@type"/></td>
                <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat( number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
                </td>
            </tr>
            <xsl:if test="StationEquation">
                <xsl:for-each select="StationEquation">
                    <tr>
                        <td align="right" colspan="2" lang="en">EQNBK</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" colspan="2" lang="en">EQNAHD</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="End/@type"/></td>
                <td align="right">( <xsl:value-of select="End/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Entrance Radius:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Exit Radius:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Length:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Angle:</td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
                </td>
                <td lang="en">
                    <xsl:if test="@rotationDirection='cw'">Right</xsl:if>
                    <xsl:if test="@rotationDirection = 'ccw'">Left</xsl:if>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Constant:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@aConstant))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Long Tangent:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Short Tangent:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Long Chord:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Xs:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Ys:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">P:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@p))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">K:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must include only one horizontal alignment with at least one curve in the <em>Include
                </em> field on the <em>Tools &gt; XML Reports &gt; Geometry</em> command to get results 
                from this report.&#xa0; This report is not suitable for multiple alignments.
            </p>
            <p class="normal1" lang="en">
                This report lists each element separately in each curve set.&#xa0; This is different than 
                the <em>Curve Sets </em> option in the <em>Geometry &gt; Review Horizontal</em> command.
            </p>
            <p class="normal1" lang="en">
                This report is not suitable for XML data produced by versions earlier than V8.8.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2010 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
