<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Vertical Alignment Review Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Vertical Alignment Review Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Last Revised:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <xsl:for-each select="HorizontalAlignment[VerticalAlignment]">
                                    <table class="margin" width="75%">
                                <colgroup span="4">
                                    <col width="23%"/>
                                    <col width="18%"/>
                                    <col width="31%"/>
                                    <col width="28%"/>
                                </colgroup>
                                        <thead>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br/>Horizontal Alignment:</th>
                                                <td align="left" colspan="2" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Horizontal Description:</th>
                                                <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Horizontal Style:</th>
                                                <td align="left" colspan="2"><xsl:value-of select="@style"/></td>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <xsl:for-each select="VerticalAlignment">
                                                <tr>
                                                    <th align="right" colspan="2" lang="en"><br/>Vertical Alignment:</th>
                                                    <td align="left" colspan="2" valign="bottom"><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Vertical Description:</th>
                                                    <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Vertical Style:</th>
                                                    <td align="left" colspan="2"><xsl:value-of select="@style"/></td>
                                                </tr>
                                                <tr>
                                                    <th/>
                                                    <th/>
                                                    <th align="right" class="underline" lang="en">Station</th>
                                                    <th align="right" class="underline" lang="en">Elevation</th>
                                                </tr>
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="VerticalLine">
        <tr>
            <td align="left" colspan="4" lang="en"><br/>Element: Linear</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <tr>
                <td align="right" colspan="2" lang="en">EQNBK</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">EQNAHD</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@grade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalSymmetricalParabola">
        <tr>
            <td align="left" colspan="4" lang="en"><br/>Element: Symmetrical Parabola</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <tr>
                <td align="right" colspan="2" lang="en">EQNBK</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">EQNAHD</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="TurningPoint">
            <tr>
                <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/></td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2" lang="en">Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@verticalCurveLength))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Grade:</td>
           <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
           </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">r = (g2 - g1) / L:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@rateOfChange))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">K = l / (g2 - g1):</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@kValue))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Middle Ordinate:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@midOrdinate))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalUnsymmetricalParabola">
        <tr>
            <td align="left" colspan="4" lang="en"><br/>Element: Unsymmetrical Parabola</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVCC/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVCC/station/@externalStation), string(PVCC/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVCC/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <tr>
                <td align="right" colspan="2" lang="en">EQNBK</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">EQNAHD</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="TurningPoint">
            <tr>
                <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/></td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@startVerticalCurveLength))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@endVerticalCurveLength))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">r = (g2 - g1) / L:</td>
            <td align="right">
                Entrance: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@startRateOfChange))"/>
            </td>
            <td align="right">
                Exit: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@endRateOfChange))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">K = l / (g2 - g1):</td>
            <td align="right">
                Entrance: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@startKValue))"/>
            </td>
            <td align="right">
                Exit: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@endKValue))"/>
           </td>
        </tr>
        <tr>
           <td align="right" colspan="2" lang="en">Middle Ordinate:</td>
           <td align="right">
               <xsl:value-of select="cif:distanceFormat(number(@midOrdinate))"/>
           </td>
       </tr>
    </xsl:template>

    <xsl:template match="VerticalCircle">
        <tr>
            <td align="left" colspan="4" lang="en"><br/>Element: Circular</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalCenter/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalCenter/station/@externalStation), string(VerticalCenter/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalCenter/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <tr>
                <td align="right" colspan="2" lang="en">EQNBK</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">EQNAHD</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="TurningPoint">
            <tr>
                <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/></td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2" lang="en">Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalClothoid">
        <tr>
            <td align="left" colspan="4" lang="en"><br/>Element: Clothoid</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <tr>
                <td align="right" colspan="2" lang="en">EQNBK</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">EQNAHD</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
        </tr>
        <xsl:if test="TurningPoint">
            <tr>
                <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/></td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Angle:</td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
            </td>
            <td>
                <xsl:if test="@rotationDirection='cw'">Right</xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'">Left</xsl:if>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Long Tangent:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Short Tangent:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Long Chord:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Xs:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Ys:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">P:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@p))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">K:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Grade:</td>
            <td align="right">
                <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must select at least one Civil vertical geometry element to get results from this report.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
