<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>

  <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <xsl:choose>
      <xsl:when test="$xslShowHelp = 'true'">
        <xsl:call-template name="StyleSheetHelp"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="InRoads">
          <xsl:for-each select="SurveyFieldbook">
            <xsl:text>Point Name,Northing,Easting,Elevation,Feature Definition&#xd;</xsl:text>
            <xsl:for-each select="SurveyPointList/SurveyPoint">
              <xsl:value-of select="@name"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="@code"/>
              <xsl:text>&#xd;</xsl:text>
            </xsl:for-each>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
           You must have at least one field book in Project Explorer (Survey) which contains a minimum of one point feature / data to get results from this report.
	</p>

<p class="normal1">For best results, run the report from the Details panel.  Select All Point Features or any combination of Point Features in Project Explorer, which populates the Details panel. Note the point features do not need to be displayed.  Highlight the row(s) to be included in the report, right click, and select Report on Selected Items.
</p>
<p class="normal1">Running the report from the generic survey report tool, or right clicking on a graphic only reports on the individually selected element. 
</p>
            <p class="normal1">Once the Civil Report Browser is open, you can select any other point features report, which utilizes the same data as the original report.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
