<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY"/>
  <!-- Unique cross section surfaces -->
  <xsl:variable name="uniqueSurfaceName" select="//CrossSectionSurfaces/CrossSectionSurface[not (@name = preceding::CrossSectionSurface/@name)]/@name"/>
  <!-- Cross Section Gradebook with Northing/Easting Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Cross Section Gradebook with Northing/Easting Report</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">Cross Section Gradebook with Northing/Easting Report</h2>
                <p lang="en">
                  Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br />
                  Time:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>
              <!-- Cross Section Set Data -->
              <xsl:for-each select="CrossSectionSet">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Set Name:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@setName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Alignment Name:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@alignmentName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                      <td align="left" style="font-size: 80%">
                        <xsl:value-of select="../@inputGridScaleFactor" />
                      </td>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Note:&#xa0; </strong>All units in this report are in
                        <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                        unless specified otherwise.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>
                <!-- Cross Section Point Data -->
                <table class="margin" width="90%">
                  <xsl:for-each select="$uniqueSurfaceName[../@type = 1]">
                    <tr>
                      <th align="left" lang="en">Surface:&#xa0; </th>
                      <td align="left" colspan="3">
                        <xsl:value-of select="."/>
                      </td>
                    </tr>
                    <xsl:for-each select="//CrossSectionSurface[@name = current()]">
                      <xsl:for-each select="CrossSectionPoints">
                        <tr>
                          <th align="left" lang="en">Station:&#xa0; </th>
                          <td align="left" colspan="3" nowrap="nowrap">
                            <xsl:value-of select="cif:stationFormat(number(../../../Station/@externalStation), string(../../../Station/@externalStationName))"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Feature</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td class="sidepad" align="right">
                              <xsl:value-of select="@name"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Offset</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:distanceFormat(number(@offset))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Elevation</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Northing</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Easting</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Existing Ground</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:ordinateFormat(number(@existingGroundElevation))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <th align="left" lang="en">Slope</th>
                          <xsl:for-each select="CrossSectionPoint[@name] | CrossSectionPoint[not (@name) and @offset = 0.0]">
                            <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
                              <xsl:value-of select="cif:gradeFormat(number(@slope))"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <td>&#xa0;</td>
                        </tr>
                      </xsl:for-each>
                    </xsl:for-each>
                  </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Notes</h4>
      <p class="normal1" lang="en">
        You must have created cross sections along your alignment and the cross section set must
        have the surfaces and features upon which you wish to report displayed.
      </p>
      <p class="normal1" lang="en">
        You can create the XML data file from the <em>
          Evaluation &gt; Cross Section &gt; Cross
          Section Report
        </em> command or from the <em>End-Area Volumes</em> leaf of the <em>
          Evaluation &gt; Cross Section &gt; Cross Sections
        </em> command by toggling on the <em>
          Create XML Report
        </em> option on the <em>General</em> leaf.
      </p>
      <p class="normal1" lang="en">
        This report works only with surfaces whose <em>Type</em> on the <em>Main</em> tab of the
        <em>Surface &gt; Surface Properties</em> command is set to <em>Design</em>.
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2006 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
