<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <p lang="en">
                </p>
              </center>

              <xsl:for-each select="GeometryProject">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>

                  </tbody>
                </table>
                <hr/>

                <!-- From Custom Point Station Offset Elevation Feature command -->
                <xsl:for-each select="HorizontalAlignment[OffsetPoint]">
                  <table cellspacing="4" width="100%">
                    <thead style="display:table-header-group">
                     </thead>
                    <tbody>
                      <xsl:for-each select="OffsetPoint/GeometryPointProperties">
                        <tr>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(@northing))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(@easting))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:stationFormat(number(station/@externalStation),string(station/@externalStationName))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:distanceFormat(number(@offset))"/>
                          </td>
<xsl:text>  |Point\Labels\Station - Offset Label</xsl:text>
<xsl:text>&#xd;</xsl:text>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>

                <!--From Alignment Station Offset command -->
                <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                  <table cellspacing="4" width="100%">
                    <tbody>
                      <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                        <tr>
                          <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                            <tr>
                             </tr>
                          </xsl:if>
                        <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@northing))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@easting))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@elevation))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation),string(centerLinePoint/point/station/@externalStationName))"/><xsl:text>|</xsl:text>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:distanceFormat(number(@firstOffset))"/>
                          </td>
<xsl:text>  |Point\Labels\Station - Offset Label</xsl:text>
<xsl:text>&#xd;</xsl:text>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>


              </xsl:for-each>

            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Notes</h4>
      <p class="normal1" lang="en">
        You must create station offset points for this report by selecting <em>
          Tools &gt; XML
          Reports &gt; Station Offset
        </em>.
      </p>
      <p class="normal1" lang="en">
        You must include at least one horizontal alignment or one feature on the <em>General</em>
        leaf in the <em>From</em> fields.
      </p>
      <p class="normal1" lang="en">
        You must also include at least one horizontal alignment on the <em>
          Horizontal Alignments
        </em> leaf or one feature on the <em> Features</em> leaf.
      </p>
      <p class="normal1" lang="en">
        You must choose at least one option on the <em>Include</em> leaf (<em>
          Horizontal On-
          Alignment Points, Horizontal Event Points, Vertical On-Alignment Points, Vertical Event
          Points
        </em> or <em>Interval</em>.)
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2013 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
