<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <!--Turnout Report-->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!--Title displayed in browser Title Bar-->
                <title lang="en">Turnout Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!--Report Title-->
                                <h2 lang="en">Turnout Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            
                            <!--Project Data-->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />
                                <xsl:for-each select="Turnout">
                                    <table class="margin" cellpadding="2" cellspacing="1" width="90%">
                                        <thead>
                                            <colgroup span="6">
                                                <col width="20%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                            </colgroup>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td align="left" colspan="6" lang="en"><strong>Turnout:&#xa0; </strong>
                                                    <xsl:value-of select="@name"/>
                                                    <xsl:text>&#xa0;</xsl:text>
                                                    <xsl:value-of select="@description"/>
                                                    (<xsl:value-of select="@style"/>)
                                                </td>
                                            </tr>
                                            <tr>
                                              <td align="left" colspan="6" lang="en">
                                                  <i>Placement</i>:&#xa0;<xsl:value-of select="@placement"/>,&#xa0;
                                                  <i>Heading</i>:&#xa0;<xsl:value-of select="@hand"/>,&#xa0;
                                                  <i>Orientation</i>:&#xa0;<xsl:value-of select="@orientation"/>
                                              </td>
                                            </tr>
                                          <xsl:apply-templates />
                                        </tbody>
                                    </table>
                                    <hr />
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    
    <!-- Turnout Horizontal Line Data -->
    <xsl:template match="HorizontalLine">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Element Type</th>
                <th align="right" lang="en">Start Northing</th>
                <th align="right" lang="en">Start Easting</th>
                <th align="right" lang="en">Length</th>
                <th align="right" lang="en">Start Radius</th>
                <th align="right" lang="en">End Radius</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Linear</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>   
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(0.))"/>
            </td>   
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(0.))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Horizontal Circle Data -->
    <xsl:template match="HorizontalCircle">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Element Type</th>
                <th align="right" lang="en">Start Northing</th>
                <th align="right" lang="en">Start Easting</th>
                <th align="right" lang="en">Length</th>
                <th align="right" lang="en">Start Radius</th>
                <th align="right" lang="en">End Radius</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Circular</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Horizontal Spiral Data -->
    <xsl:template match="HorizontalSpiral">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Element Type</th>
                <th align="right" lang="en">Start Northing</th>
                <th align="right" lang="en">Start Easting</th>
                <th align="right" lang="en">Length</th>
                <th align="right" lang="en">Start Radius</th>
                <th align="right" lang="en">End Radius</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Clothoid</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td> 
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
            </td> 
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Points -->
    <xsl:template match="TurnoutPoint">
        <xsl:if test="preceding-sibling::*[1][name() != 'TurnoutPoint']">
            <tr>
                <td></td>
            </tr>
            <tr>
                <th align="left"  lang="en">Point Name</th>
                <th align="right" lang="en">Northing</th>
                <th align="right" lang="en">Easting</th>
                <th align="right" lang="en">Elevation</th>
                <th align="right" lang="en">Radius</th>
                <th align="right" lang="en">Offset</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left"><xsl:value-of select="GeometryPoint/@name"/></td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/@radius))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/@offset))"/>
            </td>
            <td />
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Copyright 2018 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
