<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Cant ASCII Import Format -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads/GeometryProject">
                    <xsl:text/>
                    <xsl:for-each select="HorizontalAlignment[*/CantAlignment]/Superelevation/CantAlignment/Cant">
                        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName)), 21)"/>
                        <xsl:value-of select="cif:columnFormat(cif:formatNumber(number(@designSpeed), 0), 11)"/>
                        <xsl:value-of select="cif:columnFormat(cif:formatNumber(number(@appliedCant)), 11)"/>
                        <xsl:text>&#xd;</xsl:text>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Notes&#xd;&#xd;</xsl:text>
        <xsl:text>    You must include at least one horizontal alignment in&#xd;</xsl:text>
        <xsl:text>    the Include field on the Tools &gt; XML Reports &gt;&#xd;</xsl:text>
        <xsl:text>    Geometry command.&#xd;&#xd;</xsl:text>
        <xsl:text>    You must also toggle on the Include Cant Alignments&#xd;</xsl:text>
        <xsl:text>    option and select either All or Active to get results&#xd;</xsl:text>
        <xsl:text>    from this report.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2007 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
